#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"

#define KAZ_KEM_SP_J						122
#define KAZ_KEM_SP_SL						256

#define KAZ_KEM_SP_N						"29421818394147345935036136135391375994024126405325576672227398037493559452008116283594709069097880319117946343281357631447556041903884586208161678710597469727999746179863045388559147407457068275815914914983896392757878683919189075898269550939868181179868469970964809582599153788719655"
#define KAZ_KEM_SP_LN						942 // in binary (118 bytes)

#define KAZ_KEM_SP_g1						"65563"
#define KAZ_KEM_SP_g2						"65617"

#define KAZ_KEM_SP_Og1N						"99154693887499828557116081873795155652147461554242228686027806044656980768000"
#define KAZ_KEM_SP_LOg1N					256 // in binary (33 bytes)
#define KAZ_KEM_SP_Og2N						"297464081662499485671348245621385466956442384662726686058083418133970942304000"
#define KAZ_KEM_SP_LOg2N					257 // in binary (33 bytes)

#define KAZ_KEM_PUBLICKEY_BYTES				118 // in bytes for each A1, A2
#define KAZ_KEM_PRIVATEKEY_BYTES			33 // in bytes for each a1, a2

#define KAZ_KEM_EPHERMERAL_PUBLIC_BYTES		118 // in bytes for each B1, B2
#define KAZ_KEM_EPHERMERAL_PRIVATE_BYTES	33 // in bytes for each b1, b2

#define KAZ_KEM_GENERAL_BYTES				118 // in bytes for message, encapsulate message, decapsulate message

extern void init_random();
extern void clear_random();
extern void KAZ_KEM_RANDOM(mpz_t lb, mpz_t ub, mpz_t out);

extern int KAZ_KEM_KEYGEN(unsigned char *kaz_kem_public_key,
                           unsigned char *kaz_kem_private_key);

extern int KAZ_KEM_ENCAPSULATION(unsigned char *encapsulation, unsigned long long *encaplen,
                                 const unsigned char *m, unsigned long long mlen,
                                 const unsigned char *kaz_kem_public_key);

extern int KAZ_KEM_DECAPSULATION(unsigned char *decapsulation, unsigned long long *decaplen,
                                 const unsigned char *encapsulation, unsigned long long encaplen,
                                 const unsigned char *kaz_kem_private_key);

#endif // FILE_H_INCLUDED
